﻿//////////////////////////////////////////////
// ExporterLoadResult.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkExport
#include "../Dll/DllDefines.h"

#include "../Errors/ExportError.h"

#include "../Tree/Node.h"

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Class ------------------------------------

namespace nkExport
{
	struct DLL_EXPORT_EXPORT ExporterLoadResult final
	{
		// Attributes
		// Resulting tree
		nkMemory::UniquePtr<Node> _tree ;

		// Error if necessary
		ExportError _error ;

		// Functions
		ExporterLoadResult () noexcept ;
		ExporterLoadResult (const ExporterLoadResult&) = delete ;
		ExporterLoadResult (ExporterLoadResult&& other) noexcept ;
	} ;
}